<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductVariation extends Model 
{

    protected $table = 'product_variations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('variation_name', 'product_id', 'price', 'quantity', 'status');

    public function details()
    {
        return $this->hasMany('App\Models\ProductVariationDetail');
    }

    public function product()
    {
        return $this->belongsTo('App\Models\Product');
    }

}